<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Exceptions;

use PaypalServerSdkLib\ApiHelper;

/**
 * The error details.
 */
class SearchErrorException extends ApiException
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $messageProperty;

    /**
     * @var string
     */
    private $debugId;

    /**
     * @var string|null
     */
    private $informationLink;

    /**
     * @var \PaypalServerSdkLib\Models\TransactionSearchErrorDetails[]|null
     */
    private $details;

    /**
     * @var \PaypalServerSdkLib\Models\LinkDescription[]|null
     */
    private $links;

    /**
     * @var int|null
     */
    private $totalItems;

    /**
     * @var int|null
     */
    private $maximumItems;

    /**
     * @param string $reason
     * @param \PaypalServerSdkLib\Http\HttpRequest $request
     * @param \PaypalServerSdkLib\Http\HttpResponse $response
     * @param string $name
     * @param string $messageProperty
     * @param string $debugId
     */
    public function __construct(
        string $reason,
        \PaypalServerSdkLib\Http\HttpRequest $request,
        \PaypalServerSdkLib\Http\HttpResponse $response,
        string $name,
        string $messageProperty,
        string $debugId
    ) {
        parent::__construct($reason, $request, $response);
        $this->name = $name;
        $this->messageProperty = $messageProperty;
        $this->debugId = $debugId;
    }

    /**
     * Returns Name.
     * The human-readable, unique name of the error.
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * Sets Name.
     * The human-readable, unique name of the error.
     *
     * @required
     * @maps name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * Returns Message Property.
     * The message that describes the error.
     */
    public function getMessageProperty(): string
    {
        return $this->messageProperty;
    }

    /**
     * Sets Message Property.
     * The message that describes the error.
     *
     * @required
     * @maps message
     */
    public function setMessageProperty(string $messageProperty): void
    {
        $this->messageProperty = $messageProperty;
    }

    /**
     * Returns Debug Id.
     * The PayPal internal ID. Used for correlation purposes.
     */
    public function getDebugId(): string
    {
        return $this->debugId;
    }

    /**
     * Sets Debug Id.
     * The PayPal internal ID. Used for correlation purposes.
     *
     * @required
     * @maps debug_id
     */
    public function setDebugId(string $debugId): void
    {
        $this->debugId = $debugId;
    }

    /**
     * Returns Information Link.
     * The information link, or URI, that shows detailed information about this error for the developer.
     */
    public function getInformationLink(): ?string
    {
        return $this->informationLink;
    }

    /**
     * Sets Information Link.
     * The information link, or URI, that shows detailed information about this error for the developer.
     *
     * @maps information_link
     */
    public function setInformationLink(?string $informationLink): void
    {
        $this->informationLink = $informationLink;
    }

    /**
     * Returns Details.
     * An array of additional details about the error.
     *
     * @return \PaypalServerSdkLib\Models\TransactionSearchErrorDetails[]|null
     */
    public function getDetails(): ?array
    {
        return $this->details;
    }

    /**
     * Sets Details.
     * An array of additional details about the error.
     *
     * @maps details
     *
     * @param \PaypalServerSdkLib\Models\TransactionSearchErrorDetails[]|null $details
     */
    public function setDetails(?array $details): void
    {
        $this->details = $details;
    }

    /**
     * Returns Links.
     * An array of request-related [HATEOAS links](/docs/api/reference/api-responses/#hateoas-links).
     *
     * @return \PaypalServerSdkLib\Models\LinkDescription[]|null
     */
    public function getLinks(): ?array
    {
        return $this->links;
    }

    /**
     * Sets Links.
     * An array of request-related [HATEOAS links](/docs/api/reference/api-responses/#hateoas-links).
     *
     * @maps links
     *
     * @param \PaypalServerSdkLib\Models\LinkDescription[]|null $links
     */
    public function setLinks(?array $links): void
    {
        $this->links = $links;
    }

    /**
     * Returns Total Items.
     * The total number of transactions. Valid only for `RESULTSET_TOO_LARGE`.
     */
    public function getTotalItems(): ?int
    {
        return $this->totalItems;
    }

    /**
     * Sets Total Items.
     * The total number of transactions. Valid only for `RESULTSET_TOO_LARGE`.
     *
     * @maps total_items
     */
    public function setTotalItems(?int $totalItems): void
    {
        $this->totalItems = $totalItems;
    }

    /**
     * Returns Maximum Items.
     * The maximum number of transactions. Valid only for `RESULTSET_TOO_LARGE`.
     */
    public function getMaximumItems(): ?int
    {
        return $this->maximumItems;
    }

    /**
     * Sets Maximum Items.
     * The maximum number of transactions. Valid only for `RESULTSET_TOO_LARGE`.
     *
     * @maps maximum_items
     */
    public function setMaximumItems(?int $maximumItems): void
    {
        $this->maximumItems = $maximumItems;
    }

    /**
     * Converts the SearchErrorException object to a human-readable string representation.
     *
     * @return string The string representation of the SearchErrorException object.
     */
    public function __toString(): string
    {
        return ApiHelper::stringify(
            'SearchErrorException',
            [
                'name' => $this->name,
                'messageProperty' => $this->messageProperty,
                'debugId' => $this->debugId,
                'informationLink' => $this->informationLink,
                'details' => $this->details,
                'links' => $this->links,
                'totalItems' => $this->totalItems,
                'maximumItems' => $this->maximumItems
            ],
            parent::__toString()
        );
    }
}
